#cs ----------------------------------------------------------------------------

 Remmanaut, the autoit RMM tool

 Script function:		Maintains Remmanaut connectors and database
 Version:				0.2.3

 Author:				Faldo / Erik Ribbhammar
 UDF Credits:			lod3n (_RunReadStd), dantay9 (TCP File Transfer),
						Prog@ndy (MySQL, _TCPconnect), Greg Laabs (_http)
 Helping Credits:

#ce ----------------------------------------------------------------------------
#NoTrayIcon
#include <Array.au3>
#include <File.au3>
#include <Date.au3>
#include <mysql.au3>

;Predefined variables
Global $DBName = "remmanaut"
GLobal $MySQLSession

While 1

	;------------------Check agent online status------------------
	_Open_MySql($DBName)

	;Select all agents from DB
	$query = "SELECT * FROM agents;"
	$SQL_Result = _MySQL_Real_Query($MySQLSession, $query)
	If $SQL_Result = 0 then ; No SQL error
		$result = _MySQL_Store_Result($MySQLSession)
		$array = _MySQL_Fetch_Result_StringArray($result)

		;If there are agents in DB, check checkin time
		If IsArray($array) Then
			For $i = 1 to UBound($array)-1

				$timediff = _DateDiff('s', $array[$i][2], _NowCalc())
				If $timediff > $array[$i][5]/1000+1 Then
					$query = "UPDATE agents SET status='offline' WHERE agent_id='"& $array[$i][0]&"'"
					$SQL_Result = _MySQL_Real_Query($MySQLSession, $query)
				Else
					$query = "UPDATE agents SET status='online' WHERE agent_id='"& $array[$i][0]&"'"
					$SQL_Result = _MySQL_Real_Query($MySQLSession, $query)
				EndIf

			Next

		EndIf

		_MySQL_Free_Result($result)
	Else
		_FileWriteLog(@ScriptDir & "\log.txt", "MySQL error while selecting: "& _MySQL_Error($MysqlSession))
	EndIf
	_Close_MySql()


	Sleep (5000)
WEnd




; Functions -----------------------------------------------------

Func _Open_MySQL($DB)
	;Initiate MySql library
	_MySQL_InitLibrary()
	If @error Then _FileWriteLog(@ScriptDir & "\log.txt", "Error initiating MySQL")

	;Initiate MySQL connection and connect to root
	$MySQLSession = _MySQL_Init()
	$Connection = _MySQL_Real_Connect($MysqlSession,"localhost","root","")
	If $Connection = 0 Then
		$errno = _MySQL_errno($MysqlSession)
		_FileWriteLog(@ScriptDir & "\log.txt", "MySQL error while selecting: "& _MySQL_Error($MysqlSession))
		If $errno = $CR_UNKNOWN_HOST Then _FileWriteLog(@ScriptDir & "\log.txt", "Error:","$CR_UNKNOWN_HOST" & @LF & $CR_UNKNOWN_HOST)
	Endif

	;Select databse for Use
	$SQL_Return = _MySQL_Real_Query($MysqlSession, "USE "&$DB)
	If $SQL_Return <> 0 then
		_FileWriteLog(@ScriptDir & "\log.txt", "MySQL error: "& _MySQL_Error($MysqlSession))
	EndIf
EndFunc

Func _Close_MySql()
	;Close the MySql session
	_MySQL_Close($MysqlSession)
	;Close the MySql library
	_MySQL_EndLibrary()
EndFunc